//
//  EasyJSWebView.m
//  EasyJS
//
//  Created by Lau Alex on 19/1/13.
//  Copyright (c) 2013 Dukeland. All rights reserved.
//

#import "EasyJSWebView.h"
#import "Order.h"
#import "DataSigner.h"
#import <AlipaySDK/AlipaySDK.h>

//APP端签名相关头文件
#import "payRequsestHandler.h"
#import "WXApiObject.h"
#import "WXApi.h"


@implementation EasyJSWebView

@synthesize proxyDelegate;

- (id)initWithFrame:(CGRect)frame{
    self = [super initWithFrame:frame];
    if (self) {
		[self initEasyJS];
    }
    return self;
}
- (id)init{
	self = [super init];
    if (self) {
		[self initEasyJS];
    }
    return self;
}
- (id)initWithCoder:(NSCoder *)aDecoder{
	self = [super initWithCoder:aDecoder];
	
	if (self){
		[self initEasyJS];
	}
	
	return self;
}

- (void) initEasyJS{
	self.proxyDelegate = [[EasyJSWebViewProxyDelegate alloc] init];
	self.delegate = self.proxyDelegate;
}

- (void) setDelegate:(id<UIWebViewDelegate>)delegate{
	if (delegate != self.proxyDelegate){
		self.proxyDelegate.realDelegate = delegate;
	}else{
		[super setDelegate:delegate];
	}
}

- (void) addJavascriptInterfaces:(NSObject*) interface WithName:(NSString*) name{
	[self.proxyDelegate addJavascriptInterfaces:interface WithName:name];
}


@end


@implementation MyJSInterface

@synthesize viewController;

-(id) initWithViewController:(UIViewController* )viewController
{
    self = [super init];
    if(self)
    {
        self.viewController = viewController;

    }
    return self;
}



-(void) performClick:(NSString*) paymentId amount:(NSString*) amount
{
    NSLog(@"%@ %@", paymentId, amount);
}

-(void) performClick:(NSString*) paymentId amount:(NSString*) amount outTradeNo:(NSString*) outTradeNo methodID1:(NSString*) methodID1
{
    NSLog(@"%@ %@ %@ %@", paymentId, amount, outTradeNo, methodID1);
}

-(void) performClick:(NSString*) paymentId amount:(NSString*) amount outTradeNo:(NSString*) outTradeNo methodID:(NSString*) methodID
{
    NSLog(@"%@ %@ %@ %@", paymentId, amount, outTradeNo, methodID);
    
    if([methodID isEqualToString: @"1"]){
    /*============================================================================*/
    /*=======================需要填写商户app申请的===================================*/
    /*============================================================================*/
    NSString* partner = @"2088021474273374";
    NSString* seller = @"cloudcomspace@hotmail.com";
    NSString* privateKey = [NSString stringWithFormat:@"%@%@%@%@%@%@%@%@%@%@%@%@%@%@", @"MIICeAIBADANBgkqhkiG9w0BAQEFAASCAmIwggJeAgEAAoGBAOVAqfkPbLKLbBRH\n",
    @"UIlmFqTWj2i4MYVH79p06YnuoxmySQZogmVvozWqh8CKhyYLWbe6Rvk479Cnoa4t\n" ,
    @"YihNB9kYI0ajU3Ji2HYDcMQE3Iuj3LRVs43/JkzDRCtm+CMKpv8YvsuF2GPzVWnh\n" ,
    @"1MqYlBI+5HARmDqsaZXoA1gZUDBDAgMBAAECgYBRafdy9aFaftzxDqpxQQoFnBTt\n" ,
    @"0Yv0kymA4UgWreLKO2BnoDG+qDjD1D3FiOyZ/Cnub37I/wlbhkyKuJ9FRKXmLOsa\n" ,
    @"K4npbk0+SxBSMHf4p6JDPISbcfQCodL6BFzXPl6S6fPA+3C2hqw07fUOl2O2WL1V\n" ,
    @"vZAjUeWeIQKbp05p8QJBAPd3scGKJUJpfOquFfiMSHEz5cVlEkVl1RfF4dtcVzOp\n" ,
    @"IvFGbYClednAUV/9Pz7svS/MG67HNdQzITMHYwEr5MUCQQDtKDFaNPPlsHT39Bju\n" ,
    @"ezxcUKXsX44Fvd17biRUpWn/cw4yFpgmZf77ybiid2Gt+MCxsQ/fMvKmtII6tPAf\n" ,
    @"nuFnAkEA000Rq5cgn2dhMSV6PyLRTE+q9vSJOFZuMIFXi616C/N0kZ24LGue8q5D\n" ,
    @"DXo4war1E1XtoTwaG1mZFHBPOhXXnQJBAMbiyyi8ecIpjp6W3gW54fAFTnEB3cgg\n" ,
    @"50ppHxzBsDgjlEcbPbQOG52rGSVe+tL8ZxVdyVLElkyJ2yFCtpG+G4cCQQDa+yIj\n" ,
    @"FZiEB8hymZlRn0Cv3N9g2EcliKiAu/MP61gGYz0wbM5fTcCUlu78jMz1NW4Ndejh\n" ,
    @"yTHoQEiyqfxiBwh4"];
    /*============================================================================*/
    /*============================================================================*/
    /*============================================================================*/
    
    //partner和seller获取失败,提示
    if ([partner length] == 0 ||
        [seller length] == 0 ||
        [privateKey length] == 0)
    {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"提示"
                                                        message:@"缺少partner或者seller或者私钥。"
                                                       delegate:self
                                              cancelButtonTitle:@"确定"
                                              otherButtonTitles:nil];
        [alert show];
        return;
    }
    
    NSString* notifyURL = @"http://cloudcomspace.cloudapp.net/Payments/PaymentNotifyAction";
    
    /*
     *生成订单信息及签名
     */
    //将商品信息赋予AlixPayOrder的成员变量
    Order *order = [[Order alloc] init];
    order.partner = partner;
    order.seller = seller;
    order.tradeNO = outTradeNo;
    order.productName = @"Product subject";
    order.productDescription = @"Product body";
    order.amount = @"0.01";
    order.notifyURL =  notifyURL;
    
    order.service = @"mobile.securitypay.pay";
    order.paymentType = @"1";
    order.inputCharset = @"utf-8";
    order.itBPay = @"30m";
    order.showUrl = @"m.alipay.com";
    
    //应用注册scheme,在AlixPayDemo-Info.plist定义URL types
    NSString *appScheme = @"alisdkdemo";
    
    //将商品信息拼接成字符串
    NSString *orderSpec = [order description];
    NSLog(@"orderSpec = %@",orderSpec);
    
    //获取私钥并将商户信息签名,外部商户可以根据情况存放私钥和签名,只需要遵循RSA签名规范,并将签名字符串base64编码和UrlEncode
    id<DataSigner> signer = CreateRSADataSigner(privateKey);
    NSString *signedString = [signer signString:orderSpec];
    
    //将签名成功字符串格式化为订单字符串,请严格按照该格式
    NSString *orderString = nil;
    if (signedString != nil) {
        orderString = [NSString stringWithFormat:@"%@&sign=\"%@\"&sign_type=\"%@\"",
                       orderSpec, signedString, @"RSA"];
        
        [[AlipaySDK defaultService] payOrder:orderString fromScheme:appScheme callback:^(NSDictionary *resultDic) {
            NSLog(@"reslut = %@",resultDic);
        }];
    }
    }
    else{
        if([methodID isEqualToString:@"2"])
            
        {
            //[self.testClass testFunction];
          
            //{{{
            //本实例只是演示签名过程， 请将该过程在商户服务器上实现
            
            //创建支付签名对象
            payRequsestHandler *req = [payRequsestHandler alloc];
            //初始化支付签名对象
            [req init:APP_ID mch_id:MCH_ID];
            //设置密钥
            [req setKey:PARTNER_ID];
            
            //}}}
            
            //获取到实际调起微信支付的参数后，在app端调起支付
            NSMutableDictionary *dict = [req sendPay_demo:outTradeNo];
            
            if(dict == nil){
                //错误提示
                NSString *debug = [req getDebugifo];
                
                [self alert:@"提示信息" msg:debug];
                
                NSLog(@"%@\n\n",debug);
            }else{
                NSLog(@"%@\n\n",[req getDebugifo]);
                //[self alert:@"确认" msg:@"下单成功，点击OK后调起支付！ hey"];
                
                NSMutableString *stamp  = [dict objectForKey:@"timestamp"];
                
                //调起微信支付
                PayReq* req             = [[PayReq alloc] init];
                req.openID              = [dict objectForKey:@"appid"];
                req.partnerId           = [dict objectForKey:@"partnerid"];
                req.prepayId            = [dict objectForKey:@"prepayid"];
                req.nonceStr            = [dict objectForKey:@"noncestr"];
                req.timeStamp           = stamp.intValue;
                req.package             = [dict objectForKey:@"package"];
                req.sign                = [dict objectForKey:@"sign"];
                
                [WXApi sendReq:req];
            }

        }

    }

    
}

//客户端提示信息
- (void)alert:(NSString *)title msg:(NSString *)msg
{
    UIAlertView *alter = [[UIAlertView alloc] initWithTitle:title message:msg delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
    
    [alter show];
}


@end

